unit OrgMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, OrgBase, StdCtrls, ComCtrls, Db, DBTables, OrgTools, OrgDC,
  Buttons, ImgList, Grids, DBGrids;

type
  TOrgChartDemoFm = class(TForm)
    Panel1: TPanel;
    OrgTable: TTable;
    PersonTable: TTable;
    PrintPreviewBtn: TSpeedButton;
    PrintBtn: TSpeedButton;
    ZomComboBox: TComboBox;
    ComboBox2: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    OrgControl1: TOrgControl;
    Image1: TImage;
    Panel2: TPanel;
    Label1: TLabel;
    Image2: TImage;
    DBGrid1: TDBGrid;
    Splitter1: TSplitter;
    DBGrid2: TDBGrid;
    PageLineShowBtn: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure PrintPreviewBtnClick(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
    procedure ZomComboBoxChange(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure DataSource1DataChange(Sender: TObject; Field: TField);
    procedure PageLineShowBtnClick(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
  private
		procedure LoadOrgChartData(Level: Integer);
  public
    { Public declarations }
  end;

var
  OrgChartDemoFm: TOrgChartDemoFm;

implementation

{$R *.DFM}

procedure TOrgChartDemoFm.LoadOrgChartData(Level: Integer);
var
	ItemStyle: TItemStyle;
	DataControl: TDataControl;
  OrgBaseDataInfo: TOrgBaseDataInfo;
begin
  Screen.Cursor := crHourGlass;

  // μ Ӽ ϱ  ü
  OrgBaseDataInfo := TOrgBaseDataInfo.Create;
  OrgBaseDataInfo.Contents.Font.Color := clBlack;

  // ü μ ϱ ü
	DataControl := TDataControl.Create;
  DataControl.RootOrgID := 'A0000';

  OrgTable.DisableControls;
  PersonTable.DisableControls;

  PersonTable.CancelRange;
  try
  	if Level = -1 then OrgTable.CancelRange
    else OrgTable.SetRange([1], [Level]);

    OrgTable.First;
    while Not OrgTable.Eof do
    begin
      // μ  Ӽ  ϴ.
      OrgBaseDataInfo.ID := OrgTable.FieldByName('CODE').AsString;
      OrgBaseDataInfo.Contents.Font.size := 9;
      OrgBaseDataInfo.Contents.Content.Clear;

      ItemStyle := OrgBaseDataInfo.Contents.Content.Add(OrgTable.FieldByName('NAME').AsString);
      ItemStyle.Font.style := [fsbold];
      ItemStyle.Font.Size  := 10;
      ItemStyle.Align 		 := mlCenter;

      OrgBaseDataInfo.Contents.Content.Add(' ');
      if PersonTable.FindKey([OrgTable.FieldByName('PERSON_ID').AsString]) then
      begin
        ItemStyle := OrgBaseDataInfo.Contents.Content.Add(PersonTable.FieldByName('DUTY_NAME').AsString);
        ItemStyle.Font.style := [fsbold, fsUnderline	];
        ItemStyle.Font.Size  := 9;
        ItemStyle.Align 		 := mlCenter;

        OrgBaseDataInfo.Contents.Content.Add(' ');

        ItemStyle := OrgBaseDataInfo.Contents.Content.Add(PersonTable.FieldByName('NAME').AsString);
        ItemStyle.Font.Size  := 9;
        ItemStyle.Align 		 := mlCenter;
      end
      else
      begin
        OrgBaseDataInfo.Contents.Content.Add('NA');
        OrgBaseDataInfo.Contents.Content.Add('NA');
        OrgBaseDataInfo.Contents.Content.Add('NA');
      end;

      // ּұ̸    ̰ ȴ.
      OrgBaseDataInfo.Contents.MinWidthCharLength  := 12;
      OrgBaseDataInfo.Contents.MaxWidthCharLength  := 20;
      OrgBaseDataInfo.Contents.MinHeightCharLength := 6;
      OrgBaseDataInfo.Contents.MaxHeightCharLength := 6;

      // μ ¿  μ μ Ҽ ִ.
      if OrgTable.FieldByName('TYPE').AsString = '01' then
        OrgBaseDataInfo.OrgType := otOrgSupport //μ
      else
        OrgBaseDataInfo.OrgType := otOrgBase;

      DataControl.OrgAdd(OrgTable.FieldByName('CODE').AsString,      // μ ĺڵ
                         OrgTable.FieldByName('LEVEL').AsFloat,      // μ Level
                         OrgTable.FieldByName('NAME').AsString,      // μ
                         OrgTable.FieldByName('HIGH_CODE').AsString, // μ
                         OrgTable.FieldByName('TYPE').AsString, OrgBaseDataInfo); // , μ Ӽ ü
      OrgTable.Next;
    end;
  finally
    OrgControl1.LoadDataSet(DataControl, dlDataControlLoad);
    OrgBaseDataInfo.Free;
    DataControl.Free;

	  OrgTable.EnableControls;
  	PersonTable.EnableControls;

	  Screen.Cursor := crDefault;
  end;
end;

procedure TOrgChartDemoFm.FormShow(Sender: TObject);
begin
  PersonTable.Open;
	OrgTable.Open;

  // Load Org Chart Data
	LoadOrgChartData(-1);
  OrgTable.First;
end;

procedure TOrgChartDemoFm.PrintPreviewBtnClick(Sender: TObject);
begin
	OrgControl1.Preview;
end;

procedure TOrgChartDemoFm.PrintBtnClick(Sender: TObject);
begin
	OrgControl1.Print;
end;

procedure TOrgChartDemoFm.ZomComboBoxChange(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
	OrgControl1.Zoom := StrToInt(StringReplace(ZomComboBox.Items.Strings[ZomComboBox.ItemIndex], '%', '', [rfReplaceAll]));
  OrgControl1.AutoFitWidthPage;
  Screen.Cursor := crDefault;
end;

procedure TOrgChartDemoFm.SpeedButton1Click(Sender: TObject);
begin
//	OrgControl1.PageControl.RowPages := StrToInt(RowPage.Text);
//	OrgControl1.PageControl.ColPages := StrToInt(ColPage.Text);
end;

procedure TOrgChartDemoFm.DataSource1DataChange(Sender: TObject;
  Field: TField);
begin
  PersonTable.SetRange([OrgTable.FieldByName('Person_ID').AsString], [OrgTable.FieldByName('Person_ID').AsString]);
end;

procedure TOrgChartDemoFm.PageLineShowBtnClick(Sender: TObject);
begin
	OrgControl1.PageControl.PageOutLine := Not OrgControl1.PageControl.PageOutLine;
  if OrgControl1.PageControl.PageOutLine then
  	PageLineShowBtn.Caption := 'Page line Hide'
  else
  	PageLineShowBtn.Caption := 'Page line Show';
end;

procedure TOrgChartDemoFm.ComboBox2Change(Sender: TObject);
begin
	if ComboBox2.ItemIndex = 0 then LoadOrgChartData(-1)
  else LoadOrgChartData(ComboBox2.ItemIndex );
end;

end.
